# Creación de nodos, un árbol y su recorrido
# en orden
#
# Fraga 05.11.2021

class Nodo :
	def __init__( self, llave ) : 
		self.llave = llave 
		self.izq = None
		self.der = None
		self.p = None

	def imprime( self ) :
		print( self.llave, end=' ' )

	def imprime_diagrama( self ) :
		print( self.llave, " [label=\"", self.llave, "\"] ;"  )
		if self.izq is not None :
			print( self.llave, " -> ", self.izq.llave, " ;" )  
		if self.der is not None :
			print( self.llave, " -> ", self.der.llave, " ;" )  

def camina_en_orden_arbol( a ) :
	if a is not None :
		camina_en_orden_arbol( a.izq )
		a.imprime( )
		camina_en_orden_arbol( a.der )
	
def diagrama_en_orden_arbol( a ) :

	if a is not None :
		diagrama_en_orden_arbol( a.izq )
		a.imprime_diagrama( )
		diagrama_en_orden_arbol( a.der )

def hace_diagrama( a ) :
	print( "digraph Tree {" )
	print( "node [shape=circle] ;" )
	diagrama_en_orden_arbol( a )
	print( "}" )

#
#                    6
#            4                7
#        2       5                   8

# Construyo explícitamente este árbol:

raiz = Nodo( 6 )

raiz.izq = Nodo( 4 )
raiz.izq.p = raiz
raiz.der = Nodo( 7 )
raiz.der.p = raiz


raiz.izq.izq = Nodo(2)
raiz.izq.izq.p = raiz.izq
raiz.izq.der = Nodo(5)
raiz.izq.der.p = raiz.izq

raiz.der.der = Nodo(8)
raiz.der.der.p = raiz.der

# camina_en_orden_arbol( raiz )
hace_diagrama( raiz )

