import numpy as np
from sklearn.model_selection import train_test_split
from sklearn import tree

# Cargamos los datos
D = np.loadtxt( "blobs.csv", delimiter=',' )
print( D.shape )

X = D[:, 0:2]
y = D[:, 2]
print( X.shape )
print( y.shape )

# Separamos los datos para entrenamiento y prueba
X_entrena, X_prueba, y_entrena, y_prueba = train_test_split( X, y, random_state=21 )

clasificador = tree.DecisionTreeClassifier( random_state=2 )

clasificador.fit(X_entrena, y_entrena)

# y_estimadas = clasificador.predict( y_prueba )

error_entrena = clasificador.score(X_entrena, y_entrena)
print( "Exactitud de entrenamiento", error_entrena )

error_prueba = clasificador.score(X_prueba, y_prueba)
print( "Exactitud de prueba", error_prueba )

try:
	arch = open( "arbol1.dot", 'w' )
except:
 	print( "No puedo abrir el archivo arbol.dot" )

tree.export_graphviz( clasificador, out_file=arch, feature_names=[ "A", "B" ] )
arch.close( )

r = tree.export_text( clasificador, feature_names=[ "A", "B" ] )
print(r)

print( "Importancia de las características:" )
print( clasificador.feature_importances_ )

