import numpy as np
from sklearn.model_selection import cross_val_score
from sklearn.svm import SVC
from sklearn.model_selection import train_test_split


# Las repeticiones de bootstrap
n = 200


D = np.loadtxt( "blobs_1.csv", delimiter=',' )
m, _ = D.shape
X = D[:,0:2]
y = D[:,2]

clasificador = SVC(kernel='linear', C=1, random_state=42)


exactitud = np.zeros( n )
indices = np.zeros( m, dtype=np.int32 )

i = 0
while i < n :
	# Muestramos con reemplazamiento
	j = 0
	while j < m :
		indices[j] = np.random.randint( m )
		j += 1

	# Separamos los datos en datos de entrenamiento y de prueba
	X_entrena, X_prueba, y_entrena, y_prueba = train_test_split( X[indices], y[indices],
	                                                             random_state=1)
	clasificador.fit( X_entrena, y_entrena )
	exactitud[i] = clasificador.score( X_prueba, y_prueba )

	i += 1

m = np.mean(exactitud)
de = np.std(exactitud)

print( m, de )
