import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import MinMaxScaler

# Leo los datos
A = np.loadtxt( "blobs.csv", delimiter=',' )
print( A.shape )

X = A[:,0:2]
y = A[:,2]

escalador = MinMaxScaler( feature_range=(-1, 1) )
escalador.fit( X )

E = escalador.transform( X )

V = np.hstack( (E, y.reshape(-1,1) ) )

np.savetxt( "blobs_1.csv", V, fmt='%.5e', delimiter=',' )

print( escalador.data_min_ )
print( escalador.data_max_ )
