import numpy as np
from sklearn.model_selection import LeaveOneOut
from sklearn.svm import SVC
 


D = np.loadtxt( "blobs_1.csv", delimiter=',' )
n, _ = D.shape
X = D[:,0:2]
y = D[:,2]

clasificador = SVC(kernel='linear', C=1, random_state=42)

loo = LeaveOneOut()
loo.get_n_splits(X)

exactitud = np.zeros( n )

for i, (train_index, test_index) in enumerate(loo.split(X)):
	Xentrena = X[ train_index ]
	Xprueba  = X[ test_index ]
	yentrena = y[ train_index ]
	yprueba  = y[ test_index ]
	modelo = clasificador.fit( Xentrena, yentrena ) 
	exactitud[i] = clasificador.score( Xprueba, yprueba )
	print(i, yprueba )

print( exactitud )
print( np.mean( exactitud ) )
print( np.std( exactitud ) )

