import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.neighbors import KNeighborsClassifier

# Leo los datos
A = np.loadtxt( "iris.csv", delimiter=',', skiprows=1, max_rows=100 )
print( A.shape )

X = A[:,0:2]
y = A[:,4]

# Separamos los datos en datos de entrenamiento y de prueba
X_entrena, X_prueba, y_entrena, y_prueba = train_test_split( X, y, random_state=1)

clasificador = KNeighborsClassifier( n_neighbors=5 )
clasificador.fit( X_entrena, y_entrena )

exactitud = clasificador.score( X_prueba, y_prueba )
print( "Exactitud=", exactitud )

