import numpy as np
from sklearn.model_selection import train_test_split
import matplotlib.pyplot as plt

# Leo los datos
A = np.loadtxt( "iris.csv", delimiter=',', skiprows=1, max_rows=100 )
print( A.shape )

X = A[:,0:2]
y = A[:,4]

# Separamos los datos en datos de entrenamiento y de prueba
X_entrena, X_prueba, y_entrena, y_prueba = train_test_split( X, y, random_state=1)

# va = np.array( [[ 2.88294144, -2.61170345]] )
# s = -7.56710338

vx = np.linspace( 4, 7.2, 10 )
vy = ( -2.88294144 * vx - (-7.56710338) )/(-2.61170345)

fig, [ex1, ex2] = plt.subplots(ncols=2, nrows=1 )
ex1.scatter( X_entrena[:,0], X_entrena[:,1], c=y_entrena )
ex1.set_xlim( 4, 7.2 )
ex1.set_ylim( 1.8, 4.6 )
ex1.plot( vx, vy )

ex2.scatter( X_prueba[:,0], X_prueba[:,1], c=y_prueba )
ex2.set_xlim( 4, 7.2 )
ex2.set_ylim( 1.8, 4.6 )
ex2.plot( vx, vy )
plt.show( )
