import numpy as np
from sklearn.model_selection import train_test_split
import matplotlib.pyplot as plt

# Leo los datos
A = np.loadtxt( "iris.csv", delimiter=',', skiprows=1, max_rows=100 )
print( A.shape )

X = A[:,0:2]
y = A[:,4]

# Separamos los datos en datos de entrenamiento y de prueba
X_entrena, X_prueba, y_entrena, y_prueba = train_test_split( X, y, random_state=1)

va = np.array( [[ 2.88294144, -2.61170345]] )
s = -7.56710338

def decision( x ) :
	v = x @ va.T + s

	# No es necesario calcular la probabilidad
	if v > 0.0 :
		return 1, v
	else:
		return 0, v

n, m = X_prueba.shape
vx = np.zeros( n ) 
vy = np.zeros( n ) 
i = 0
while i < n :
	v, v1 = decision( X_prueba[i] )
	# print( i, y_prueba[i], v )
	vx[i] = v1[0]
	vy[i] = 1/(1+np.exp(-v1[0]))
	# print( v1[0], 1/(1+np.exp(-v1[0])) )
	i += 1

fig, ex = plt.subplots( )
ex.scatter( vx, vy, c=y_prueba )
ex.grid( )
plt.show( )
