import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.linear_model import LogisticRegression

# Leo los datos
A = np.loadtxt( "blobs.csv", delimiter=',' )
print( A.shape )

X = A[:,0:2]
y = A[:,2]

# Separamos los datos en datos de entrenamiento y de prueba
X_entrena, X_prueba, y_entrena, y_prueba = train_test_split( X, y, random_state=1)

clasificador = LogisticRegression( multi_class='ovr' )
clasificador.fit( X_entrena, y_entrena )

exactitud = clasificador.score( X_prueba, y_prueba )
print( "Exactitud=", exactitud )

# El modelo
print( clasificador.classes_ )
print( clasificador.coef_ )
print( clasificador.intercept_ )
