import numpy as np
from sklearn.model_selection import train_test_split
import matplotlib.pyplot as plt

# Leo los datos
A = np.loadtxt( "blobs.csv", delimiter=',' )
print( A.shape )

X = A[:,0:2]
y = A[:,2]

# Separamos los datos en datos de entrenamiento y de prueba
X_entrena, X_prueba, y_entrena, y_prueba = train_test_split( X, y, random_state=1)

# El modelo
# Exactitud= 1.0
# [0. 1. 2.]
# [[ 1.16792235  1.28577829]
#  [-2.41280348  0.5981981 ]
#  [ 1.1042649  -2.0526744 ]]
# [ 2.53204193 -8.02314051 -1.91096474]

vx = np.linspace( -7, 2, 20 )
vy1 = (-1.16792235*vx - 2.53204193)/1.28577829
vy2 = ( 2.41280348*vx + 8.02314051)/0.5981981
vy3 = (-1.1042649*vx + 1.91096474)/(-2.0526744)


fig, [ex1, ex2] = plt.subplots( ncols=2, nrows=1 )

ex1.scatter( X_entrena[:,0], X_entrena[:,1], c=y_entrena )
ex1.plot( vx, vy1, c='red' )
ex1.plot( vx, vy2, c='green' )
ex1.plot( vx, vy3, c='blue' )

ex2.scatter( X_prueba[:,0], X_prueba[:,1], c=y_prueba )
ex2.plot( vx, vy1, c='red' )
ex2.plot( vx, vy2, c='green' )
ex2.plot( vx, vy3, c='blue' )

plt.show( )
