import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import MinMaxScaler

# Leo los datos
A = np.loadtxt( "iris.csv", delimiter=',', skiprows=1 )
print( A.shape )

X = A[:,0:4]
y = A[:,4]

escalador = MinMaxScaler( feature_range=(-1, 1) )
escalador.fit( X )

E = escalador.transform( X )

V = np.hstack( (E, y.reshape(-1,1) ) )

np.savetxt( "iris_11.csv", V, fmt='%.5e', delimiter=',' )

print( escalador.data_min_ )
print( escalador.data_max_ )
