import sklearn.datasets as samples_generator
import matplotlib.pyplot as plt
import numpy as np

X, y = samples_generator.make_circles( n_samples=200, noise=0.1, factor=0.35, random_state=9 )
# print( X.shape )
# print( y )

fig, axis = plt.subplots( )
axis.scatter( X[:,0], X[:,1], c=y )
axis.set_aspect( 1 )

plt.show( )

D = np.hstack( [X, y.reshape(-1,1)] )

np.savetxt( "circulos.csv", D, delimiter=',' )

