import numpy as np
#
# 2 características
# 1 salida
# 3 neuronas en la capa oculta
# La red será
# 2 3 1

# 2x4
C2 = np.array([[ 34.16419243,   3.00946356,   8.83534327, -13.09634453],
               [ -7.70912613,   2.51434112,  11.27869261,  39.95531865]])

# 4x1
C3 = np.array([[ 33.04805708],
               [-34.24966064],
               [-32.55157147],
               [ 32.42237112]])

vs2 = np.array([18.26948588, 23.00432476, -7.23596569, 20.69488794])
vs3 = np.array([-9.14427273])

def evalua( x ) :
	#   1x2 2x4   1x4
	#     1x4     1x4
	S2 = x @ C2 + vs2
	O2 = 1.0/(1.0 + np.exp( -S2 ) ) 
	#
	#   1x3  3x1   1x3
	S3 = O2 @ C3 + vs3
	O3 = 1.0/(1.0 + np.exp( -S3 ) ) 

	return np.where( O3>=0.5, 1, 0 )
 
