# decision surface for logistic regression on a binary classification dataset
import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.metrics import confusion_matrix
import matplotlib.pyplot as plt
import modelo

# Leemos los datos del archivo
D = np.loadtxt("circulos.csv", delimiter=',' )
print( D.shape )

# Tenemos que separar los datos en datos para el
# entrenamiento del modelo y datos
# para probar el modelo

X = D[:,0:2]
y = D[:,2]

X_entrena, X_prueba, y_entrena, y_prueba = train_test_split( X, y, random_state=21)

# define bounds of the domain
min1, max1 = -1.2, 1.2
min2, max2 = -1.2, 1.2 

# define the x and y scale
x1vec = np.arange(min1, max1, 0.01)
x2vec = np.arange(min2, max2, 0.01)

# create all of the lines and rows of the grid
xx, yy = np.meshgrid(x1vec, x2vec)

# flatten each grid to a vector
r1, r2 = xx.flatten(), yy.flatten()
r1, r2 = r1.reshape((len(r1), 1)), r2.reshape((len(r2), 1))

# horizontal stack vectors to create x1,x2 input for the model
grid = np.hstack((r1,r2))

# make predictions for the grid
print( grid.shape )
yhat = modelo.evalua(grid)
# reshape the predictions back into a grid
zz = yhat.reshape(xx.shape)

fig, ex = plt.subplots( )

# plot the grid of x, y and z values as a surface
ex.set_aspect(1)
ex.contourf(xx, yy, zz, cmap='Paired')
# create scatter plot for samples from each class
for class_value in range(2):
	# get row indexes for samples with this class
	row_ix = np.where(y_prueba == class_value)
	# create scattr of these samples
	ex.scatter(X_prueba[row_ix, 0], X_prueba[row_ix, 1], cmap='Paired')

# show the plot
plt.show()

