import numpy as np
#
# 2 características
# 3 clases
# 5 neuronas en la capa oculta
# La red será
# 2 5 3

# 2 x 5 
C2 = np.array([[-13.34845905,  -2.5369855 , -10.06273826,  -6.02774368, -4.98423917],
       [  5.34580378,  -1.24366159,  14.5645509 ,  -5.71052661, -6.01952402]])

# 5 x 3
C3 = np.array([[-0.24397172,  8.32612431, -7.55018625],
       [-4.44995188,  1.6774413 ,  2.71495423],
       [ 3.19317616,  4.51840832, -8.47572858],
       [-7.84748794,  1.58828846,  5.79731526],
       [-8.79672606, -0.08103503,  8.18678391]])

vs2 = np.array([-22.40658147,  -1.87641514,  -6.53858093,  -9.8927062 , -9.73436219])

vs3 = np.array([15.77195077, -9.01915953, -6.94285381])

# softmax

def evalua( x ) :
	#   1x2 2x4   1x4
	#     1x4     1x4
	S2 = x @ C2 + vs2
	O2 = 1.0/(1.0 + np.exp( -S2 ) ) 
	#
	#   1x3  3x1   1x3
	S3 = O2 @ C3 + vs3
	O3 = 1.0/(1.0 + np.exp( -S3 ) ) 

	v = np.max( O3, axis=1 )
	# print( "v=", v.shape )

	O3 = O3 - v.reshape(-1,1)
	E = np.exp(O3)

	return np.argmax( E/np.sum(E, axis=1).reshape(-1,1), axis=1 )
 
