from sklearn.svm import SVC
from sklearn.model_selection import train_test_split
import numpy as np

# Con 20 datos y C=1e6 se presenta sobreajuste
# y se corrige haciendo C=1
D = np.loadtxt( "lunas.csv", delimiter=',', max_rows=20 )

X = D[:,0:2]
y = D[:,2]

# Separamos los datos en datos de entrenamiento y de prueba
X_entrena, X_prueba, y_entrena, y_prueba = train_test_split( X, y, random_state=1)

clasificador = SVC( C=1 )
clasificador.fit(X_entrena, y_entrena)
exactitud = clasificador.score( X_prueba, y_prueba )
print( "Prueba:", exactitud )

exactitud = clasificador.score( X_entrena, y_entrena )
print( "Entrenamiento:", exactitud )

# These parameters can be accessed through the attributes dual_coef_
# which holds the product, support_vectors_ which holds the support vectors,
#  and intercept_ which holds the independent term 

# print( clasificador.dual_coef_ )
# print( clasificador.support_vectors_ )
# print( clasificador.intercept_ )



