import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.neural_network import MLPClassifier

# Leo los datos
A = np.loadtxt( "d.txt" )
print( A.shape )

X = A[:,0:2]
y = A[:,2]

X_entrena, X_prueba, y_entrena, y_prueba = train_test_split( X, y, random_state=21 )

clasificador = MLPClassifier( hidden_layer_sizes=(2,), activation='logistic', solver='lbfgs',
                              random_state=7 )

clasificador.fit( X_entrena, y_entrena )

e_entrena = clasificador.score( X_entrena, y_entrena ) 
print( "Exactitud entrenamiento:", e_entrena )

e_prueba = clasificador.score( X_prueba, y_prueba ) 
print( "Exactitud prueba:", e_prueba )


print( clasificador.coefs_ )
print( clasificador.intercepts_ )
print( clasificador.out_activation_ )
