import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.neural_network import MLPRegressor

# Leo los datos
A = np.loadtxt( "d.txt" )
print( A.shape )

X = A[:,0:2]
y = A[:,2]

X_entrena, X_prueba, y_entrena, y_prueba = train_test_split( X, y, random_state=21 )

regresor = MLPRegressor( hidden_layer_sizes=(2,), activation='logistic', solver='lbfgs',
                              max_iter=700, random_state=4 )

regresor.fit( X_entrena, y_entrena )

e_entrena = regresor.score( X_entrena, y_entrena ) 
print( "Exactitud entrenamiento:", e_entrena )

e_prueba = regresor.score( X_prueba, y_prueba ) 
print( "Exactitud prueba:", e_prueba )


print( regresor.coefs_ )
print( regresor.intercepts_ )
print( regresor.out_activation_ )
