# Ensamblador para el RISC0
# versión 0.1
# Fraga
# 18.02.2026
#
import sys
import re

n = len( sys.argv )
if n != 3 :
	print( "Args: nombre.asm nombre.bin" )
	sys.exit(1)

namein = sys.argv[1]
nameout = sys.argv[2]

class SymTable:
	def __init__(self):
		self.table = {}

	def define(self, name, value):
		if name in self.table:
			raise Exception("symbol %s already defined" % name)

		self.table[name] = value

	def value(self, name):
		return self.table[name]

class Code :
	def __init__(self):
		self.code = []

	def check_register( self, arg ) :
		n1 = 0
		if arg[0] == 'r' :
			n1 = arg[1:]
			if n1.isdigit( ) :
				n1 = int(n1)
				return 0, n1
			else :
				print("Error in argument ", arg )
				exit(3)
		elif arg[0:2] == '0x' :
			n1 = int( arg, 16 )
			return 1, n1
		else :
			if arg.isdigit( ) :
				n1 = int(arg)
				return 1, n1
			else :
				print( "Error in argument ", arg )
				exit(4)
	
	def moveh( self, op, arg1 ) :
		ins, n1 = self.check_register( arg1 )
		self.code.append( [op, ins, n1, 0] )

	def move( self, op, arg1, arg2 ) :
		ins, n1 = self.check_register( arg1 )
		ins, n2 = self.check_register( arg2 )
		self.code.append( [op, ins, n1, n2] )

	def arithmetic( self, op, arg1, arg2, arg3 ) :
		ins, n1 = self.check_register( arg1 )
		ins, n2 = self.check_register( arg2 )
		ins, n3 = self.check_register( arg3 )

		# I must store
		# op ins n1 n2 n3
		self.code.append( [op, ins, n1, n2, n3 ] )

	def memory( self, op, arg1, arg2, arg3 ) :	
		ins, n1 = self.check_register( arg1 )
		ins, n2 = self.check_register( arg2 )
		ins, off = self.check_register( arg3 )

		self.code.append( [op, n1, n2, off] )

	def memorySerial( self, op, arg1, arg2 ) :	
		ins, n1 = self.check_register( arg1 )
		ins, n2 = self.check_register( arg2 )
		off = 0x3fc0 
		self.code.append( [op, n1, n2, off] )

	def branch( self, op, label, line_number ) :
		self.code.append( [op, label, line_number] )
			
	def dump( self, name ) :
		orig_stdout = sys.stdout
		try:
			arch = open( name, 'w' )
		except:
			print( "ERROR: Can't open", name, "file" );
			exit(1)
		sys.stdout = arch

		n = len( self.code )
		i = 0
		while i < n :
			# print( i, self.code[i] )
			op = self.code[i][0]
			# MOV	
			if op == 0 :
				a = self.code[i][2]
				b = self.code[i][3]
				if self.code[i][1] == 0 :
					lcode = 0 | a << 24 | b << 20; 
				else :
					if b >= 0 :
						lcode = 4 << 28 | a << 24 | b ; 
					else :
						lcode = 5 << 28 | a << 24 | (0xffff & b) ; 
			# Aritmetic, logic, and shift operations
			elif op>=1 and op<=11 :
				a = self.code[i][2]
				b = self.code[i][3]
				c = self.code[i][4]
				# print( "OP", a, b, c )
				if self.code[i][1] == 0 :
					lcode = 0 | a << 24 | b << 20 | op<<16 | c; 
				else :
					if c >= 0 :
						lcode = 4 << 28 | a << 24 | b << 20 | op<<16 | c; 
					else :
						lcode = 5 << 28 | a << 24 | b << 20 | op<<16 | (0xffff & c); 

			elif op>=12 and op<=15 :
				a = self.code[i][1]
				b = self.code[i][2]
				if op >= 14 and op <=15 :
					off = 16320
				else :
					off = self.code[i][3]

				if off < 0 :
					off = 0xfffff & off

				match op :
					case 12:
						lcode = 8 << 28 | a << 24 | b << 20 | off  
					case 13:
						lcode = 10 << 28 | a << 24 | b << 20 | off  
					case 14:
						lcode = 8 << 28 | a << 24 | b << 20 | 16320  # = 0x03fc0
					case 15 :
						lcode = 10 << 28 | a << 24 | b << 20 | 16320  

			elif op>=16 and op<=19 :
				label = self.code[i][1] 
				nline = self.code[i][2] 
				# print( "AQUI", label, nline )
				# print( symtable.value(label) )
				v = symtable.value(label) - nline - 1
				if v < 0 :
					v = 0xffffff & v
				match op :
					case 16:
						c = 7   # TRUE
					case 17:
						c = 1   # ZERO
					case 18:
						c = 5   # Less than
					case 19:
						c = 14  # Greater than

				lcode = 14 << 28 | c << 24 | v  
			elif op==30:
				a = self.code[i][2]
				lcode = 0 | 2 << 28 | a << 24  

			print( '{:08x}'.format(lcode) )
			
			i += 1

		sys.stdout = orig_stdout
		arch.close( )

symtable = SymTable( )
mycode = Code( )

instruction = [
 { 'op' : 'start', 'args' : 0 },
 { 'op' : 'mov', 'id' : 0, 'args' : 2 },
 { 'op' : 'movh', 'id' : 30, 'args' : 1 },
 { 'op' : 'lsl', 'id' : 1, 'args' : 3 },
 { 'op' : 'asr', 'id' : 2, 'args' : 3 },
 { 'op' : 'ror', 'id' : 3, 'args' : 3 },
 { 'op' : 'and', 'id' : 4, 'args' : 3 },
 { 'op' : 'ann', 'id' : 5, 'args' : 3 },
 { 'op' : 'ior', 'id' : 6, 'args' : 3 },
 { 'op' : 'xor', 'id' : 7, 'args' : 3 },
 { 'op' : 'add', 'id' : 8, 'args' : 3 },
 { 'op' : 'sub', 'id' : 9, 'args' : 3 },
 { 'op' : 'mul', 'id' : 10, 'args' : 3 },
 { 'op' : 'div', 'id' : 11, 'args' : 3 },
 { 'op' : 'ld' , 'id' : 12, 'args' : 3 },
 { 'op' : 'st' , 'id' : 13, 'args' : 3 },
 { 'op' : 'lds' , 'id' : 14, 'args' : 2 },
 { 'op' : 'sts' , 'id' : 15, 'args' : 2 },
 { 'op' : 'br' , 'id' : 16, 'args' : 1 },
 { 'op' : 'brz', 'id' : 17, 'args' : 1 },
 { 'op' : 'brlt', 'id' : 18,'args' : 1 },
 { 'op' : 'brgt', 'id' : 19,'args' : 1 },
 { 'op' : 'end', 'args' : 0 },
]

def check_instruction_and_comment( tokens, nline ) :
	ntoks = len( tokens )
	i = 0

	if tokens[0][-1] == ':' :
		label = tokens[0][:-1]
		symtable.define( label, nline )
		# print( "'", label, "'", "is a label" )
		return 3

	# Check if it is a correct instruction
	else :
		n = len( instruction )
		i = 0
		flag = 0
		while i < n :
			if instruction[i]['op'] == tokens[0] :
				flag = 1
				break
			i += 1
		
		if flag==0 :	
			print( tokens[0], "is not a valid instruction" )
			return -1
		elif i == 0 :  # 'start' 
			return 1
		elif i == n-1: # 'end' 
			return 2

	nargs = instruction[i]['args']
	if nargs < ntoks-1 :
		if tokens[nargs+1][0] != '#' :
			print( "Bad comment" )	
			return -1

	# print( instruction[i] )
	nall = len( instruction ) - 1
	if  i>=1 and i<=nall :
		nid = instruction[i]['id']

		if nid==0 :
			mycode.move( 0, tokens[1], tokens[2] )
		elif nid>=1 and nid<=11 :
			mycode.arithmetic( nid, tokens[1], tokens[2], tokens[3] )
		elif nid>=12 and nid<=13 :
			mycode.memory( nid, tokens[1], tokens[2], tokens[3] )
		elif nid>=14 and nid<=15 :
			mycode.memorySerial( nid, tokens[1], tokens[2] )
		elif nid>=16 and nid<=19 :
			mycode.branch( nid, tokens[1], nline )
		elif nid==30 :
			mycode.moveh( 30, tokens[1] )

	return 0

###################################################

try:
	infile = open( namein )
except:
	print("No se puede abrir el archivo", namein )
	sys.exit(2)

estado = 0
nlinea = 0
while 1 :
	linea = infile.readline( )
	if linea == "" :
		break

	linea = linea.lower()
	tokens = linea.split( )

	n = len( tokens )
	if n == 0:
		continue

	if tokens[0][0] == "#" :
		# print( "Comentario" )
		continue

	# print( "Line", nlinea )
	r = check_instruction_and_comment( tokens, nlinea )
	if r < 0 :
		print( "Error tokens[0] in line ", nlinea )
		exit(1)
	elif r == 1 and estado==0 :
		estado=1
		continue
	elif r == 2 and estado==1 :
		estado=2
		continue
	elif r == 3 : # A label
		continue

	nlinea += 1

if estado != 2 :
	print( "ERROR: No 'start' or 'end' operation in input file" )

infile.close( ) 

# Second stage
mycode.dump( nameout )
