#include <stdio.h>
#include <stdlib.h>

void divide( int x, int y )
{
	int r0, r1, r2, r3;
	unsigned int lastbit;
	int q0, q1, q2;
	int d, quot, rem;
	int i;
/**
assign r0 = (S == 0) ? 0 : r3;
assign q0 = (S == 0) ? x : q2;

assign r1 = {r0[30:0], q0[31]};
assign d = r1 - y;
assign r2 = d[31] ? r1 : d;
assign q1 = {q0[30:0], ~d[31]};


assign rem = r2;
assign quot = q1;

always @ (posedge(clk)) begin
  r3 <= r2; q2 <= q1;
**/

	r0 = 0;
	q0 = x;
	for( i=0; i<32; i+=1 ){
		// assign r1 = {r0[30:0], q0[31]};
		r1 = r0 << 1;
		lastbit = 0x80000000 & q0;
		if( lastbit )
		 	r1 = r1 | 0x00000001;
	
		// assign d = r1 - y;
		d = r1 - y;
	
		// assign r2 = d[31] ? r1 : d;
		lastbit = 0x80000000 & d;
		if( ! lastbit )
			r2 = d;
		else 
			r2 = r1;

		// assign q1 = {q0[30:0], ~d[31]};
		q1 = q0 << 1;
		if ( lastbit == 0 ) 
			q1 = q1 | 0x00000001;

		// assign rem = r2;
		// assign quot = q1;
		// rem = r2;
		// quot = q1;
		// printf("%d 0x%x 0x%x\n", i, q0, q1 );
	
  		//# r3 <= r2; q2 <= q1;
		r3 = r2;
		q2 = q1;

		//# assign r0 = (S == 0) ? 0 : r3;
		r0 = r3;
		//# assign q0 = (S == 0) ? x : q2;
		q0 = q2;
	}

	printf( "%d %d\n", q1, r2 );
}

/**
# The invariants Q*y + R = x and 0 ≤ R < y*232-i are maintained over the iterations, with i = 32
# Q*y + R = x and 0 ≤ R < y*2^{32-i}, with i = 32
**/

int main( int argc, char *argv[] )
{
	int x, y;

	if( argc != 3 ) {
		fprintf( stderr,  "Args: numerador denominador\n" );
		return 1;
	}

	x = (int)strtol( argv[1], (char **)NULL, 10);
	y = (int)strtol( argv[2], (char **)NULL, 10);

	// printf( "%d %d\n", x, y );
	divide( x, y );
	return 0;
}
