module maquina_estados( clk, reset, x, z );
	input clk, reset, x;
	output reg z;

	// Los cuatro estados
	parameter A = 2'b00,
	          B = 2'b01,
	   	      C = 2'b10,
	          D = 2'b11;

	// Dos registros de 2 bits para guardar
	// el estado actual y el siguiente
	reg [1:0] current_state, next_state;

	// Proceso de asignación del estado siguiente
	always @(posedge clk, posedge reset)
	begin
	if(reset)
		current_state <= A;
	else
		current_state <= next_state;
	end

	always @(current_state, x)
	begin
		// Salida a cero
		z = 0;
		case(current_state)
			A:
				if(x == 1)
					next_state = B;
				else
					next_state = A;
			B:
				if(x == 1)
					next_state = B;
				else
					next_state = C;
			C:
				if(x == 1)
					next_state = B;
				else
					next_state = D;
			D:
				if(x == 1)
				begin
					z = 1;
					next_state = B;
				end
				else
					next_state = A;
		endcase
	end
endmodule
