// Simple testbench to exercise the state maquine 
module control_tb ();
	reg r_Clk = 1'b0;
	reg r_rst = 1'b0;
	reg in;	
	wire out;

	always #5 r_Clk <= !r_Clk;
 
	// Here is where we instantiate the UUT
	maquina_estados U01 ( .clk(r_Clk), .reset(r_rst), .x(in),.z(out) );


  // The steps to exercise the UUT go here
	initial
    begin
		// $dumpfile("dump.txt"); $dumpvars;
		$dumpfile("control.vcd");
		$dumpvars(0, control_tb);

		#8;
		r_rst <= 1'b1;

		#12;
		r_rst <= 1'b0;
		#5;

		in=1'b0;
		#10;
		$display( "E: %x, S: %x", in, out );

		in=1'b1;
		#10;
		$display( "E: %x, S: %x", in, out );

		#10
		$finish();
	end
endmodule
