#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "intarith.h"

/**
Para el sistema de Lorenz las ecuaciones son
\dot{x} = sigma(y-x)
\dot{y} = x(rho-z) - y
\dot{z} = xy - beta z

Su Jacobiana es 

J[0] = sigma( y' - x' )  	
J[1] = (rho - z)x' - y' - x z'  	
J[2] = yx' + xy' - beta z'

 Esta función se debe de cambiar para cualquier
otro oscilador
**/
void sistema( long *out, long *in, long *par )
{
	long x, y, z;

	x = in[0];
	y = in[1];
	z = in[2];
	out[0] = mulTrunc( par[0], y - x );
	out[1] = mulTrunc( x, par[1] - z ) - y;
	out[2] = mulTrunc( x, y ) - mulTrunc( par[2], z );
}

void integrate( long *par, long *x0, long h, int samples, long *out )
{
	long x[3], o[3];
	int i;

	// Integration using the Euler method
	x[0] = x0[0];
	x[1] = x0[1];
	x[2] = x0[2];

	// samples = (int)((float)tmax/h + 0.5); 
	for ( i=0; i<samples; i++ ) {
		sistema( o, x, par );
		x[0] += mulTrunc( h, o[0] );
		x[1] += mulTrunc( h, o[1] );
		x[2] += mulTrunc( h, o[2] );

#ifdef GRAFICA
		printf( "%lf %lf %lf\n", x[0], x[1], x[2] );
#endif

	}
	out[0] = x[0];
	out[1] = x[1];
	out[2] = x[2];
}

void do_work( long *xini, long h, int tp, int iteraciones )
{
	// El sistema es de 3er orden, se necesitan dos vectores
	long x0[3] = { 0, 0, 0 };
	long v[3];
	int i,j;
	// Valores de los parámetros para el sistema de Lorenz
	double par[3] = { 10.0, 28.0, 2.666666666666 };
	long pari[3];

	pari[0] = setNumber( par[0] );
	pari[1] = setNumber( par[1] );
	pari[2] = setNumber( par[2] );

	x0[0] = xini[0];
	x0[1] = xini[1];
	x0[2] = xini[2];

	for(i=0, j=0; i<iteraciones; i++ ) {
		// integrate( pari, x0, h, mulTrunc(h,tp),  v );
		integrate( pari, x0, h, tp,  v );

		printf("%lf %lf %lf\n", getNumber(v[0]), getNumber(v[1]), getNumber(v[2]) );

		x0[0] = v[0];
		x0[1] = v[1];
		x0[2] = v[2];
	}
}

int main( int argc, char *argv[] )
{
	long x0[3];
	long h;
	int tp, iteraciones;
	int bits;

	if( argc != 8 ) {
		fprintf( stderr, "Args: bits x0 y0 z0 h tp iteraciones\n" );
		return 1;
	}
	bits = (int)strtol( argv[1], (char **)NULL, 10); 
	initializeA( bits, 63-bits );

	x0[0] = setNumber( strtod( argv[2], (char **)NULL ) );
	x0[1] = setNumber( strtod( argv[3], (char **)NULL ) );
	x0[2] = setNumber( strtod( argv[4], (char **)NULL ) );

	h = setNumber( strtod( argv[5], (char **)NULL ) );
	tp = (int)strtol( argv[6], (char **)NULL, 10);
	iteraciones = (int)strtol( argv[7], (char **)NULL, 10);

	do_work( x0, h, tp, iteraciones );

	return 0;
}

