`timescale 10ns / 1ps  

// Simple testbench to exercise the register
module RISC0Top_tb ();

	localparam n=32;
	reg r_Clk = 1'b0;
	reg r_rst = 1'b1;
	wire RxD;
  	wire TxD;
	wire [7:0] leds;

	wire [31:0] reg0;

	always #5 r_Clk <= !r_Clk;
 
	// Here is where we instantiate the UUT

	RISC0Top micro (.clk(r_Clk),.rstIn(r_rst),.RxD(),.TxD(),.leds() );

	assign reg0 = micro.riscx.R[0]; 

  // The steps to exercise the UUT go here
	initial
    begin
		// $dumpfile("dump.txt"); $dumpvars;
		$dumpfile("micro.vcd");
		$dumpvars(0, RISC0Top_tb);

		#8;
		r_rst <= 1'b0;

		#27;
		// r_rst <= 1'b1;

		for( integer i=0; i<10; i++ )
			#20;  // 10 ciclos de reloj

		$finish();
	end
endmodule
