// `timescale 10ns / 1ps  // NW 27.5.09  LL 10.12.09  NW 28.7.2011

module RISC0Top(
  input clk,
  // input CLK50M,
  input rst_n,
  input usb_rx,
  // input [7:0] swi,
  output usb_tx,
  output [7:0] led);
	 
// wire clk, clk50;
reg rst;  // , clk25;

wire[5:0] ioadr;
wire [3:0] iowadr;
wire iowr, iord;
wire[31:0] inbus, outbus;

wire [7:0] dataTx, dataRx;
wire rdyRx, doneRx, startTx, rdyTx;
wire limit;  // of cnt0

reg [7:0] Lreg;
reg [15:0] cnt0;
reg [31:0] cnt1; // milliseconds

RISC0 riscx(.clk(clk), .rst(rst), .iord(iord), .iowr(iowr),
   .ioadr(ioadr), .inbus(inbus), .outbus(outbus));

reg block;
			
uart_rx receiver(.clk(clk), .rst(rst), .rx(usb_rx), .data(dataRx), .new_data(rdyRx));
uart_tx transmitter(.clk(clk), .rst(rst), .tx(usb_tx),.block(block),.busy(rdyTx),.data(dataTx),
                    .new_data(startTx));

// RS232T transmitter(.clk(clk), .rst(rst), .start(startTx), .data(dataTx), .TxD(TxD), .rdy(rdyTx));
// module RS232T(
// 1,2 input clk, rst,
//   3 input start, // request to accept and send a byte
//   4 input [7:0] data,
//   5 output rdyRx,
//   6 output TxD);

// module uart_tx (
//   1 input clk,
//   2 input rst,
//   6 output tx,
//   ? input block,
//   5 output busy,
//   4 input wire [7:0] data;
//   3 input new_data
// );



assign iowadr = ioadr[5:2];
assign inbus = (iowadr == 0) ? cnt1 :
    // (iowadr == 1) ? swi :
    (iowadr == 2) ? {24'b0, dataRx} :
    (iowadr == 3) ? {30'b0, rdyTx, rdyRx} : 0;
    
assign dataTx = outbus[7:0];
assign startTx = iowr & (iowadr == 2);
assign doneRx = iord & (iowadr == 2);
assign limit = (cnt0 == 25000);
assign led = Lreg;

always @(posedge clk) 
begin
  block <= 1'b0;
  rst <= ~rst_n;
  Lreg <= ~rst ? 0 : (iowr & (iowadr == 1)) ? outbus[7:0] : Lreg;
  cnt0 <= limit ? 0 : cnt0 + 1;
  cnt1 <= limit ? cnt1 + 1 : cnt1;
end

//The Clocks
/**
IBUFG clkInBuf(.I(CLK50M), .O(clk50));
always @ (posedge clk50) clk25 <= ~clk25;
BUFG clk150buf(.I(clk25), .O(clk));
**/
endmodule
