`timescale 10ns / 1ps  

// Simple testbench to exercise the register
module RISC0Top_tb ();

	localparam n=32;
	reg r_Clk = 1'b0;
	reg r_rst = 1'b1;
	wire usb_rx;
  	wire usb_tx;
	wire [7:0] leds;

	wire [31:0] reg0, reg1, reg2, reg3;

	always #2 r_Clk <= !r_Clk;
 
	// Here is where we instantiate the UUT

	RISC0Top micro (.clk(r_Clk),.rst_n(r_rst),.usb_rx(),.usb_tx(),.led() );

	assign reg0 = micro.riscx.R[0]; 
	assign reg1 = micro.riscx.R[1]; 
	assign reg2 = micro.riscx.R[2]; 
	assign reg3 = micro.riscx.R[3]; 

  // The steps to exercise the UUT go here
	initial
    begin
		// $dumpfile("dump.txt"); $dumpvars;
		$dumpfile("micro.vcd");
		$dumpvars(0, RISC0Top_tb);

		#8;
		r_rst <= 1'b0;

		#27;
		// r_rst <= 1'b1;

		#20000;  

		$finish();
	end
endmodule
