module top (
	clk,
	rst_n,
	led,
	usb_tx
);
	input wire clk;
	input wire rst_n;
	output reg [7:0] led;
	output reg usb_tx;
	//input wire usb_rx;

	reg rst;
	localparam _STAGES = 3'h4;
	reg reset_cond_in;
	wire reset_cond_out;
	reset_conditioner #(.STAGES(_STAGES)) reset_cond(
		.clk(clk),
		.in(reset_cond_in),
		.out(reset_cond_out)
	);

	reg uart_tx_block=1'b0;
	wire uart_tx_busy;
	wire uart_tx_tx;
	reg [7:0] uart_tx_data=8'h41;
	reg uart_tx_new_data=1'b0;

	uart_tx uart_tx(
		.clk(clk),
		.rst(rst),
		.tx(uart_tx_tx),
		.block(uart_tx_block),
		.busy(uart_tx_busy),
		.data(uart_tx_data),
		.new_data(uart_tx_new_data)
	);

	always @( * ) begin
		reset_cond_in = ~rst_n;
		rst = reset_cond_out;
		led = 8'hf0;
		usb_tx = uart_tx_tx;
		uart_tx_new_data=1'b0;
		if( !uart_tx_busy )
			uart_tx_new_data=1'b1;
	end


endmodule
