// Simple testbench to exercise the register
module oscilador_tb ();
	localparam n=32;
	reg r_Clk = 1'b0;
	reg r_rst = 1'b0;
	reg [n-1:0] xin, yin, zin;
	wire [n-1:0] xout, yout, zout;
	reg stf=1'b0;
	wire opr, eof;

	always #5 r_Clk <= !r_Clk;
 
	// Here is where we instantiate the UUT
	oscilador OSC (.CLK(r_Clk),.RST(r_rst),.STF(stf),.X0(xin),.Y0(yin),.Z0(zin),
                   .X(xout), .Y(yout), .Z(zout), .EOF(eof) );

	// The steps to exercise the UUT go here
	initial
    begin
		// $dumpfile("dump.txt"); $dumpvars;
		$dumpfile("oscilador.vcd");
		$dumpvars(0, oscilador_tb);

		#18;
		r_rst <= 1'b1;

		#12;
		r_rst <= 1'b0;
		#10;
		stf <= 1'b1;
		$display( "Salida: %x %x %x", xout, yout, zout );

		xin<=32'h00a00002;
		yin<=32'h01400000;
		zin<=32'h01e00000;
		$display( "Entrada: %x %x %x", xin, yin, zin );

		for( integer i=1; i<=10; i++ ) begin
			#50;
			$display( "Salida %d: %x %x %x", i, xout, yout, zout );
		end

		$finish();
	end
endmodule
