import numpy as np
import matplotlib.pyplot as plt
import serial

n = 2000
num = np.zeros( 12, dtype=np.uint32 )
sale = np.zeros( 3, dtype=np.int32 )
vx = np.zeros( n )
vy = np.zeros( n )
vz = np.zeros( n )

fig, ex = plt.subplots( )
ex.plot(vx,vy)
plt.ion()
plt.show()

escala = float(1<<17)

port = "/dev/cu.usbserial-FT4MG9OV1"

print ("Opening %s" % port)
ser = serial.Serial(port, baudrate=1000000, stopbits=1, bytesize=8 )

try:
	i = 0
	while 1 :	
		ret = int( ser.read(1).hex(), 16 )
		# print( type( ret ) )
		if ret == 0x8f :   # Inicio de la trama
			ret = ser.read(12)
			# print("o:", ret )
			j = 0
			while j < 12 :
				num[j] = int(hex(ret[j]), 16)
				j += 1

			sale[0] = num[3]<<21 | num[2]<<14 | num[1]<<7 | num[0]
			sale[1] = num[7]<<21 | num[6]<<14 | num[5]<<7 | num[4]
			sale[2] = num[11]<<21 | num[10]<<14 | num[9]<<7 | num[8]
			# print( hex(sale[0]), hex(sale[1]), hex(sale[2]) )
			if sale[0] & 0x08000000 :
				sale[0] = 0xf0000000 | sale[0] 
			if sale[1] & 0x08000000 :
				sale[1] = 0xf0000000 | sale[1] 
			if sale[2] & 0x08000000 :
				sale[2] = 0xf0000000 | sale[2] 

			vx[i] = float(sale[0])/escala
			vy[i] = float(sale[1])/escala
			vz[i] = float(sale[2])/escala
			# print( vx[i], vy[i], vz[i] )
			i += 1

			if i==n :
				# grafica( )
				ex.plot( vx, vz )
				plt.draw()
				plt.pause(0.001)
				i = 0

			ret = int( ser.read(1).hex(), 16 )
			if ret == 0x8a :   # Fin de la trama
				pass

		# print(ret.hex())
except KeyboardInterrupt:
	print( "You hit control-c" )
	ser.close( )
	exit(0)


