module control(
	clk,
	rst,
	new_tx,
	tx_data,
	tx_busy
);
	input wire clk;
	input wire rst;
	output reg new_tx;
	output reg [7:0] tx_data;
	input wire tx_busy;

	// localparam n=64;
	// localparam n=32;
	localparam n=28;
	reg STF;
	wire EOF, SALE;
	wire [n-1:0] XI; 
	wire [n-1:0] YI; 
	wire [n-1:0] ZI; 
	wire [n-1:0] XO, YO, ZO;

	// Initial values 
	/**
	assign XI = 32'h00a00000;
	assign YI = 32'h01400000;
	assign ZI = 32'h01e00000;
	**/
	assign XI = 28'h00a0000;
	assign YI = 28'h0140000;
	assign ZI = 28'h01e0000;

	// module oscilador(CLK,RST,STF,X0,Y0,Z0,X,Y,Z,EOF);

	oscilador OSC ( .CLK(clk),.RST(rst),.STF(SALE),.X0(XI),.Y0(YI),.Z0(ZI),.X(XO),.Y(YO),.Z(ZO),.EOF(EOF) );

	reg INI=0;
	ffd FFD (.RST(rst), .CLK(clk), .ENB(1'b1), .D(INI), .Q(SALE));

	reg [4:0] count_d;
	reg [4:0] count_q = 5'b00000;

	always @( * ) begin
	// {
		INI=0;

        new_tx = 1'h0;
        tx_data = 8'bxxxxxxxx;

		count_d = count_q;

		if( !tx_busy )
			count_d = count_q + 1'h1;

		case (count_q) // {
			5'h0: 
				if( EOF == 1'b1 ) begin
					count_d = 3'h1;
				end
					
			5'h1: begin
				new_tx = 1'h1;
				tx_data = 8'h8f;
			end
			5'h2: begin
				new_tx = 1'h1;
				tx_data = XO[6:0];
			end
			5'h3: begin
				new_tx = 1'h1;
				tx_data = XO[13:7];
			end
			5'h4: begin
				new_tx = 1'h1;
				tx_data = XO[20:14];
			end
			5'h5: begin
				new_tx = 1'h1;
				tx_data = XO[27:21];
			end
			5'h6: begin
				new_tx = 1'h1;
				tx_data = YO[6:0];
			end
			5'h7: begin
				new_tx = 1'h1;
				tx_data = YO[13:7];
			end
			5'h8: begin
				new_tx = 1'h1;
				tx_data = YO[20:14];
			end
			5'h9: begin
				new_tx = 1'h1;
				tx_data = YO[27:21];
			end
			5'ha: begin
				new_tx = 1'h1;
				tx_data = ZO[6:0];
			end
			5'hb: begin
				new_tx = 1'h1;
				tx_data = ZO[13:7];
			end
			5'hc: begin
				new_tx = 1'h1;
				tx_data = ZO[20:14];
			end
			5'hd: begin
				new_tx = 1'h1;
				tx_data = ZO[27:21];
			end
			5'he: begin
				new_tx = 1'h1;
				tx_data = 8'h8a;
			end
			5'hf: begin
				INI=1;
				count_d = 5'h00;
			end
		endcase // }
	end // } End always


	always @(posedge clk) 
		if (rst == 1'b1)
			count_q <= 0;
		else
			count_q <= count_d;

endmodule
