/*--------------------------------------------------------------
  ---Project: D Flip-Flop with enable pin
  ---Inputs: RST - sets the output with 0
             CLK - clock signal
             ENB - input that enables the Flip-Flop
               D - logic input
  ---Output: O - logic output
--------------------------------------------------------------*/
module ffd (RST,CLK,ENB,D,Q);
	input RST,CLK,ENB,D;
	output reg Q;

	always @ (posedge CLK or posedge RST)
	begin
	if(RST)
		Q <= 1'b0;
	else if(ENB)
		Q <= D;
	else
		Q <= Q;
	end

endmodule
