module lorenz (CLK, RST, x, y, z, dx, dy, dz);
	input CLK, RST;
	input [27:0] x, y, z;
	output [27:0] dx, dy, dz;

	wire [27:0] S1, S2, S3, S4, S5;

	/**	
	localparam SIGMA=32'h01400000;
	localparam RHO  =32'h03800000;
	localparam BETA =32'h0055559b;
	**/
	localparam SIGMA=28'h0140000;
	localparam RHO  =28'h0380000;
	localparam BETA =28'h0055559;

	subtractor SUB1(CLK, RST, y, x, S1);
	multiplier M1(CLK, RST, SIGMA, S1, dx);

	subtractor SUB2(CLK, RST, RHO, z, S2);
	multiplier M2(CLK, RST, S2, x, S3);
	subtractor SUB3(CLK, RST, S3, y, dy);

	multiplier M3(CLK, RST, x,y,S4);
	multiplier M4(CLK, RST, BETA,z,S5);
	subtractor SUB4(CLK, RST, S4, S5, dz);
endmodule
