/**
 Project: multiplier of n bits
 Inputs: A,B are logic signed inputs of n bits
 Output: O produces the arithmetic multiplication O=A*B
**/
module multiplier #(parameter n=28,parameter frac=17)
	(CLK,RST,A,B,O);

	localparam msb = n + frac - 1;
	input CLK,RST;
	input signed [n-1:0] A,B;
	output [n-1:0] O;

	wire signed [(2*n)-1:0] OT;
	wire [n-1:0] R;

	assign OT = A * B;

	//1.Truncate the result according to the Fixed-point format.
	assign R = OT[msb:frac];

	register #(n,0) U01 (RST,CLK,1'b1,R,O);

endmodule
