module oscilador(CLK,RST,STF,X0,Y0,Z0,X,Y,Z,EOF);
	input CLK, RST;
	input STF;
	input [27:0] X0, Y0, Z0;
	output [27:0] X, Y, Z;
	output EOF;

	// 0.001
	// localparam H=32'h00000831;  
	localparam H=28'h0000083;  

	wire [27:0] dx, dy, dz;
	wire [27:0] SX, SY, SZ;
	wire [27:0] SRX, SRY, SRZ;
	wire [27:0] OX, OY, OZ;
	wire SEL, OPR, EOF;
	wire [2:0] COUNT;

	lorenz Lorenz (CLK, RST, X, Y, Z, dx, dy, dz);

	multiplier M1( CLK, RST, H, dx, SX );
	adder      A1( SX, X, OX );
	register   R1( RST, CLK, OPR, OX, SRX );

	multiplier M2( CLK, RST, H, dy, SY );
	adder      A2( SY, Y, OY );
	register   R2( RST, CLK, OPR, OY, SRY );

	multiplier M3( CLK, RST, H, dz, SZ );
	adder      A3( SZ, Z, OZ );
	register   R3( RST, CLK, OPR, OZ, SRZ );

	ffd        D1( RST, CLK, OPR, 1'b1, SEL ); 
	counter #(3,5)  C1 ( RST, CLK, STF, COUNT, OPR, EOF);

	assign X = (!SEL) ? X0 : SRX;	
	assign Y = (!SEL) ? Y0 : SRY;	
	assign Z = (!SEL) ? Z0 : SRZ;	

endmodule
