// Simple testbench to exercise the register
module register_tb ();
	localparam n=3;
	reg r_Clk = 1'b0;
	reg r_rst = 1'b0;
	wire [n-1:0] wO;
	reg stf=1'b0;
	wire opr, eof;

	always #5 r_Clk <= !r_Clk;
 
	// Here is where we instantiate the UUT
	counter  #(n,5) UUT
	( .RST(r_rst), .CLK(r_Clk), .STF(stf), .COUNT(wO), .OPR(opr), .EOF(eof) );

  // The steps to exercise the UUT go here
	initial
    begin
		// $dumpfile("dump.txt"); $dumpvars;
		$dumpfile("reg.vcd");
		$dumpvars(0, register_tb);

		#8;
		r_rst <= 1'b1;
		$display("salida=%x", wO);

		#12;
		r_rst <= 1'b0;
		stf <= 1'b1;
		#20;
		$display("salida=%x", wO);
	
		#100;	
		$finish();
	end
endmodule
