// Simple testbench to exercise the register
module lorenz_tb ();
	localparam n=32;
	reg r_Clk = 1'b0;
	reg r_rst = 1'b0;
	reg [n-1:0] xin, yin, zin;
	wire [n-1:0] xout, yout, zout;
	reg stf=1'b0;
	wire opr, eof;

	always #5 r_Clk <= !r_Clk;
 
	// Here is where we instantiate the UUT
	lorenz Lorenz (.CLK(r_Clk),.RST(r_rst),.x(xin),.y(yin),.z(zin), .dx(xout),.dy(yout),.dz(zout));

  // The steps to exercise the UUT go here
	initial
    begin
		// $dumpfile("dump.txt"); $dumpvars;
		$dumpfile("lorenz.vcd");
		$dumpvars(0, lorenz_tb);

		#8;
		r_rst <= 1'b1;

		#12;
		r_rst <= 1'b0;
		stf <= 1'b1;
		#5;
		$display( "Salida: %x %x %x", xout, yout, zout );

		xin=32'h00a00002;
		yin=32'h01400000;
		zin=32'h01e00000;
		$display( "Entrada: %x %x %x", xin, yin, zin );
		// 063fffec 06e0001a 013ffbff
		#30
		$display( "Salida: %x %x %x", xout, yout, zout );
		#10

		xin=32'h00a19993;
		yin=32'h0141c287;
		zin=32'h01e051e8;
		// 06419988 06f16c4f 01580467
		$display( "Entrada: %x %x %x", xin, yin, zin );
		#30;	
		$display( "Salida : %x %x %x", xout, yout, zout );
		#10;

		xin=32'h00a3338d;
		yin=32'h01438983;
		zin=32'h01e0a9f7;
		// 06435b9c 0702b1d2 01704455
		$display( "Entrada: %x %x %x", xin, yin, zin );
		#30;	
		$display( "Salida : %x %x %x", xout, yout, zout );
		#10;
		$finish();
	end
endmodule
