/*--------------------------------------------------------------
 ---Project: ascending counter 0 to nclk-1
 ---Inputs: RST - sets the counter to zero
            CLK - clock signal ---
            STF - start counter ---
 ---Output: COUNT - gives the count value
            OPR - gives ’1’ when the count reaches nckl1-1
                nckl2 < nckl1
            EOF - gives ’1’ while COUNT is 0
--------------------------------------------------------------*/
module counter #(parameter nc=3,nclk1=6) (RST,CLK,STF,COUNT,OPR,EOF);
	input RST,CLK,STF;
	output OPR,EOF;
	output [nc-1:0] COUNT;

	wire [nc-1:0] INC;
	wire NEOF, NOPR, HLD, SEL;

	assign OPR = (COUNT == nclk1-1'b1) ? 1'b1 : 1'b0;
	assign EOF = (COUNT == 0) ? 1'b1 : 1'b0;
	assign INC = (SEL) ? COUNT + 1'b1: {nc{1'b0}};

	assign NEOF = ~EOF;
	assign NOPR = ~OPR;
	assign HLD = STF | NEOF;
	assign SEL = HLD & NOPR;

	register #(nc,0) U01 (RST,CLK,1'b1,INC,COUNT);

endmodule
