module lorenz (CLK, RST, x, y, z, dx, dy, dz);
	input CLK, RST;
	input [31:0] x, y, z;
	output [31:0] dx, dy, dz;

	wire [31:0] S1, S2, S3, S4, S5;
	
	localparam SIGMA=32'h01400000;
	localparam RHO  =32'h03800000;
	localparam BETA =32'h0055559b;

	substractor SUB1(CLK, RST, y, x, S1);
	multiplier M1(CLK, RST, SIGMA, S1, dx);

	substractor SUB2(CLK, RST, RHO, z, S2);
	multiplier M2(CLK, RST, S2, x, S3);
	substractor SUB3(CLK, RST, S3, y, dy);

	multiplier M3(CLK, RST, x,y,S4);
	multiplier M4(CLK, RST, BETA,z,S5);
	substractor SUB4(CLK, RST, S4, S5, dz);
endmodule
