/**
 Project: substractor of n bits
 Inputs: A,B are logic signed inputs of n bits
 Output: O produces the arithmetic sum O=A-B
**/
module substractor #(parameter n=32)(CLK,RST,A,B,O);
	input CLK, RST;
	input signed [n-1:0] A, B;
	output [n-1:0] O;

	wire [n-1:0] R;
	assign R = A - B;
	
	register R1 (.RST(RST),.CLK(CLK),.ENB(1'b1),.I(R),.O(O));
endmodule
