// Simple testbench for the adder
module adder_TB ();
	parameter n=8;
	reg signed [n-1:0] rA, rB;
	wire [n-1:0] wO;
 
	// Here is where we instantiate the UUT
	adder #(n) UUT
	(.A(rA), .B(rB), .O(wO));
  
  // The steps to exercise the UUT go here
  initial
    begin
      rA = 8'h01;
      rB = 8'h03;
      #10;
      $display("rA    =%x", rA);
      $display("rB    =%x", rB);
      $display("salida=%x", wO);

      rA = 8'h10;
      rB = 8'h0a;
      #10;
      $display("rA    =%x", rA);
      $display("rB    =%x", rB);
      $display("salida=%x", wO);

      rA = 8'h80;  //  0x80 = -128
      rB = 8'hfb;  //  0xfb = -5
      #10;
      $display("rA    =%x", rA);
      $display("rB    =%x", rB);
      $display("salida=%x", wO);
      $finish();
    end
endmodule
