/**
 Project: multiplier of n bits
 Inputs: A,B are logic signed inputs of n bits
 Output: O produces the arithmetic multiplication O=A*B
**/
module multiplier #(parameter n=32,parameter frac=21)
	(A,B,O);

	localparam msb = n + frac - 1;
	// input RST,CLK;
	input signed [n-1:0] A,B;
	output [n-1:0] O;

	wire signed [(2*n)-1:0] OT;
	// wire [n-1:0] R;

	assign OT = A * B;

	//1.Truncate the result according to the Fixed-point format.
	assign O = OT[msb:frac];

	//Register #(n,0) U01 (RST,CLK,1’b1,R,O);

endmodule
