// Simple testbench for the multiplier
module multiplier_tb ();
	parameter n=8;
	reg signed [n-1:0] rA, rB;
	wire [n-1:0] wO;
 
	// Here is where we instantiate the UUT
	multiplier #(n,0) UUT
	(.A(rA), .B(rB), .O(wO));
  
  // The steps to exercise the UUT go here
  initial
    begin
      rA = 8'h01;
      rB = 8'h03;
      #10;
      $display("rA    =%x", rA);
      $display("rB    =%x", rB);
      $display("salida=%x", wO);

      rA = 8'h10;
      rB = 8'h0a;
      #10;
      $display("rA    =%x", rA);
      $display("rB    =%x", rB);
      $display("salida=%x", wO);

      rA = 8'h20;  //  0x20 = 32
      rB = 8'h0a;  //  0x0a = 10
      #10;
      $display("rA    =%x", rA);
      $display("rB    =%x", rB);
      $display("salida=%x", wO);
      $finish();
    end
endmodule
