/*--------------------------------------------------------------
  ---Project: parallel-in/parallel-out (PIPO) register of n bits
  ---Inputs: RST - sets the values of the output bus with the
                   initial condition values
             CLK - clock signal 
             ENB - input that enables the register 
             I - logic input of n bits
  ---Output: O - logic output of n bits 
 --------------------------------------------------------------*/
module register #(parameter n=32,parameter init=0)
	(RST,CLK,ENB,I,O);

	input RST,CLK,ENB;
	input [n-1:0] I;
	output reg [n-1:0] O;

	always @ (posedge CLK or posedge RST)
	begin
		if(RST)
			O <= init;
		else if ( ENB )
			O <= I;
		else 
			O <= O;
	end
endmodule
