// Simple testbench to exercise the register
module register_tb #(parameter n=32) ();
	reg r_Clk = 1'b0;
	reg r_rst = 1'b0;
	reg signed [n-1:0] rA;
	wire [n-1:0] wO;

	always #5 r_Clk <= !r_Clk;
 
	// Here is where we instantiate the UUT
	register UUT 
	( .RST(r_rst), .CLK(r_Clk), .ENB(1'b1), .I(rA), .O(wO) );

  // The steps to exercise the UUT go here
	initial
    begin
      // $dumpfile("dump.txt"); $dumpvars;

		#8;
		r_rst <= 1'b1;
		$display("salida=%x", wO);

		#12;
		r_rst <= 1'b0;
		rA <= 32'hffff;
		$display("salida=%x", wO);

		#10;
		rA <= 32'h00ff;
		$display("salida=%x", wO);

		$finish();
	end
endmodule
